#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <exec/exec.h>
#include <exec/execbase.h>
#include <exec/memory.h>
#include <proto/exec.h>
#include <proto/dos.h>

#include <iec/iec.h>

//----------------------------------------
//IECCmd 1.0
//
//Sends a command to the 1541
//OPEN 15,8,15,"<cmd>" : CLOSE 15
//
//----------------------------------------


struct iecbase *IECBase;

struct RDArgs *rda;
LONG argv[2]={0,0};
char device=8;	//Default device #
char* string;	//Command string to send


char Version[]="$VER:IECCmd 1.0 (03.08.96) by Fabrizio Farenga";

//******************************************
// Send a null-terminated string to the 1541
//******************************************
void SendString(char* string)
{
int t;
for (t=0;string[t]!=0;t++) CIOut(string[t]); 
}


void SendCMD(void)
{
	Listen(device);
	Second(CMD_OPEN+15);

	if (IECBase->iec_ST==ST_OK)
		{
		UnListen();

		Listen(device);
		Second(CMD_DATA+15);
		SendString(string);	//Send the command string to the 1541
		UnListen();

		Listen(device);
		Second(CMD_CLOSE+15);
		UnListen();

		}
	else
		{
		printf ("\n?DEVICE NOT PRESENT\n\n");
		}


}


void main(void)
{

if ((rda = ReadArgs("Command/A,Device/N",argv,NULL)) != NULL)
	{
	if (argv[0]!=0) string=(char*)argv[0];		//Command string
	if (argv[1]!=0) device=*(LONG *)argv[1];	//device number
	}
	else
	{
	printf ("Required argument missing!\n\n");
	return;
	}

if ((device<4)||(device>30))
	{
	printf ("\n?DEVICE NOT PRESENT\n\n");
	return;
	}

IECBase = (struct iecbase*)OpenLibrary("iec.library",0L);

if (IECBase!=0)
	{

	SendCMD();	//Send the command to the 1541

	CloseLibrary((struct Library*)IECBase);
	}
else
	{
	printf ("Can't open iec.library\n");
	return;
	}

	if (rda!=NULL) FreeArgs(rda);


}


